/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{  Copyright (c) 2003 Borland Software Corporation      }
{                                                       }
{*******************************************************/

using System;
using System.DirectoryServices;

namespace Borland.Data.Web
{
	/// <summary>
	/// brief implementation of ADSI DirectoryService for Virtual Roots
	/// </summary>
	public class VirtualDirectory
	{
   	private const string sPath = "PATH";
		private const string sIIS = "IIS://";
		private const string sLocalHost = "localhost";
		private const string sW3SVC = "/W3SVC/";
      private const string sRoot = "/Root/";
      private const string sRootNoSlash = "/Root";
		private const string IIsWebVirtualDir = "IIsWebVirtualDir";
		private DirectoryEntry IISDE;
      private string path;
      private string FHost;


		public VirtualDirectory(string host)
		{
      	FHost = host;
         if( ClassUtils.IsEmpty(host) )
	      	path = sIIS + sLocalHost + sW3SVC;
         else
            path = sIIS + host + sW3SVC;
		}

      public DirectoryEntry FindVirtualDirectory(string VDir)
      {
         DirectoryEntry e;
      	for( int i = 1; i < 3; i++ )
         {
            e = FindVirtualDirectory(VDir, i);
            if( e != null )
            	return e;
         }
         return null;
      }

      protected DirectoryEntry FindVirtualDirectory(string VDir, int index)
      {
      	DirectoryEntry e;
         try
         {
            if( VDir == "")
	      		e = new DirectoryEntry(path + Convert.ToString(index) + sRootNoSlash);
            else
	      		e = new DirectoryEntry(path + Convert.ToString(index) + sRoot + VDir);
         	return e;
         }
         catch
         {
         }
         return null;
      }

      public string FindPathForVirtualDir(string VDir)
      {
         DirectoryEntry e;
      	for( int i = 1; i < 3; i++ )
         {
            e = FindVirtualDirectory(VDir, i);
         	if( e != null )
            {
            	Object o = null;
               try
               {
               	o = e.Properties[sPath].Value;
                  string s = Convert.ToString(o);
                  e.Close();
                  return s;
               }
               catch
               {
               	e.Close();
                  return null;
               }
            }
         }
         return null;
      }

      public bool CreateVirtualDir(String VDir, string path)
      {
      	try
         {
	   	   DirectoryEntry deRoot = null;
            for( int i = 1; i < 5; i++ )
            {
					deRoot = FindVirtualDirectory("", i);
               if( deRoot != null )
               	break;
            }
            if( deRoot == null )
               return false;
	      	DirectoryEntry deNewChild = deRoot.Children.Add(VDir, IIsWebVirtualDir);
		      deNewChild.Properties["Path"][0] = path;
      	   deNewChild.CommitChanges();
	         deRoot.CommitChanges();
   	      deNewChild.Invoke("AppCreate", true);
      	   deNewChild.CommitChanges();
         	deRoot.CommitChanges();
	         deNewChild.Close();
            deRoot.Close();
            return true;
         }
         catch
         {
         }
         return false;
      }
	}
}
